# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3): Cooperate unless opponent defects early (Grim Trigger)
    if current_round <= 3:
        if "D" in opp_history:
            return "D"
        return "C"
    
    # Middle Rounds (4-7): Tit-for-tat with exploitation check
    elif current_round <= 7:
        if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
            return "D"
        if opp_history and opp_history[-1] == "D":
            return "D"
        return "C"
    
    # Late Rounds (8-10): Preemptively defect in round 8, then conditional cooperation
    else:
        if current_round == 8:
            return "D"
        elif current_round == 9 or current_round == 10:
            if opp_history and opp_history[-1] == "C":
                return "C"
            else:
                return "D"
        return "D"